<?php
function replacementDisk()
{
   $sock = Login();
   checkActionAccess($sock, "write");
   $content_type = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : "";
   if (stripos($content_type, "application/json") === false) {
      throw new Exception("Content-Type must be application/json");
   }

   $body = file_get_contents("php://input");
   $object = json_decode($body, true);
   if (!is_array($object) || isContainNull($object)) {
      header("HTTP/1.1 400 Bad Request");
      die();
   }
   $id = $object["id"];
   $event = $object["status"] ? "mount" : "umount";
   $str = "DISK " . $id . " " . $event;
   //$str = "DISK" . $id.''. $event;
   Send($sock, $str);
   socket_close($sock);
}
